global script_node

local controls = FindNodeByName("AllControlsScript")
local prop =  FindNodeByName("atom_prop")

global function AnimDone()
	local anim = FindNodeByTag("loop_atom")
	local loop_sound = FindNodeByName("Ob_2_1Sound")
	
	prop:PlayAnim(anim, 1, 0.5)
	loop_sound:Trigger()

	controls.script.TurnOnInterface()
	--Locking down mech
	controls.script.InteractDone()
end

global function Interact()
	local doctor = GetActor("doctor")
	local amy = GetActor("amy")
	local stop_anim =  FindNodeByTag("stop_start")
	local loop_sound = FindNodeByName("Ob_2_1Sound")
	local stop = FindNodeByName("atom_stop")
	local start = FindNodeByName("atom_start")

	controls.script.TurnOffInterface()

	FindNodeByName("Console2InteractableScript").script.Object1State = 1

	-- ConsoleDV == 0 is for when exploring tardis
	if controls.script.ConsoleDV == 0 then
		SayPrep("skip","async")

		if(FindNodeByName("CommonScripts").script.DoctorIsPlayer()) then
			--VO Console Control Text
			doctor::SID_2248:Atom Accelerator: This provides the energy for travelling through time and space. It's supposed to be powered up before using the Space/Time Throttle.
			doctor::SID_2249:Although... I have been doing it the wrong way round for a while. No wonder the takeoff is a bit bumpy.
		else
			--VO Console Control Text
			amy::SID_2250:No idea what this is, but when I turn it, I can hear something powering up. Must be important.
		end
	end

	prop:PlayAnim(stop_anim,1,0.5)
	prop:SetCallback(script_node, "AnimDone")
	loop_sound:StopTrigger()
	stop:Trigger()

	Wait(3.13)
	start:Trigger()
end

global function DummyCallback()
end

global function ResetControl()
	local anim = FindNodeByTag("loop_atom")
	local loop_sound = FindNodeByName("Ob_2_1Sound")
	
	prop:SetCallback(script_node, "DummyCallback")	-- overrides the current callback so nothing happens
	prop:PlayAnim(anim, 1, 0.5)
	loop_sound:Trigger()
end
